<?php get_header(); ?>

<div class="grid grid-cols-1 md:grid-cols-3 gap-8">
    <!-- Main Content -->
    <div class="md:col-span-2">
        <?php 
        $post_id = isset($_GET['p']) ? (int)$_GET['p'] : 0;
        
        if ($post_id > 0) {
            // SINGLE POST VIEW
            $post = get_post($post_id);
            if ($post) {
                $thumb_url = get_the_post_thumbnail_url($post->ID);
                $categories = get_the_terms($post->ID, 'category');
                $gallery = get_post_meta($post->ID, '_gallery_images', true);
                $attachments = get_post_meta($post->ID, '_attachments', true);
                ?>
                <article class="bg-white p-8 rounded-lg shadow-sm">
                    <div class="mb-6">
                        <?php if ($categories): ?>
                        <div class="flex gap-2 mb-3">
                            <?php foreach($categories as $cat): ?>
                            <span class="bg-orion-100 text-orion-800 text-xs px-2 py-1 rounded-full font-semibold uppercase tracking-wide"><?php echo htmlspecialchars($cat->name); ?></span>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                        
                        <h1 class="text-4xl font-bold text-gray-900 mb-4"><?php echo htmlspecialchars($post->post_title); ?></h1>
                        
                        <div class="flex items-center text-gray-500 text-sm mb-6 border-b pb-6">
                            <span><?php echo date('d F Y', strtotime($post->post_date)); ?></span>
                            <span class="mx-2">•</span>
                            <span>By Admin</span>
                        </div>

                        <?php if ($thumb_url): ?>
                        <div class="mb-8 rounded-lg overflow-hidden shadow-md">
                            <img src="<?php echo $thumb_url; ?>" alt="<?php echo htmlspecialchars($post->post_title); ?>" class="w-full h-auto">
                        </div>
                        <?php endif; ?>

                        <div class="prose max-w-none text-gray-800 leading-relaxed mb-8">
                            <?php echo $post->post_content; // WYSIWYG content is usually HTML safe ?>
                        </div>

                        <!-- Gallery Section -->
                        <?php if ($gallery): 
                            $gallery_images = json_decode($gallery, true);
                            if (!empty($gallery_images)):
                        ?>
                        <div class="mb-8">
                            <h3 class="text-2xl font-bold mb-4 border-l-4 border-orion-500 pl-4">Galeri Foto</h3>
                            <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                                <?php foreach($gallery_images as $img): ?>
                                <a href="<?php echo $img; ?>" target="_blank" class="block aspect-square overflow-hidden rounded-lg hover:opacity-90 transition">
                                    <img src="<?php echo $img; ?>" class="w-full h-full object-cover">
                                </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; endif; ?>

                        <!-- Attachments Section -->
                        <?php if ($attachments): 
                            $att_files = json_decode($attachments, true);
                            if (!empty($att_files)):
                        ?>
                        <div class="mb-8 bg-gray-50 p-6 rounded-lg border border-gray-200">
                            <h3 class="text-xl font-bold mb-4 flex items-center">
                                <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path></svg>
                                Lampiran Dokumen
                            </h3>
                            <ul class="space-y-3">
                                <?php foreach($att_files as $att): ?>
                                <li class="flex items-center justify-between bg-white p-3 rounded border hover:shadow-sm transition">
                                    <span class="font-medium text-gray-700 truncate mr-4"><?php echo htmlspecialchars($att['name']); ?></span>
                                    <a href="<?php echo $att['url']; ?>" download class="text-orion-600 hover:text-orion-800 text-sm font-bold flex items-center">
                                        Download
                                        <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                                    </a>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php endif; endif; ?>

                        <div class="mt-8 pt-8 border-t">
                            <a href="index.php" class="inline-flex items-center text-gray-600 hover:text-orion-600 font-medium">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                                Kembali ke Berita Utama
                            </a>
                        </div>
                    </div>
                </article>
                <?php
            } else {
                echo '<div class="bg-red-100 text-red-700 p-4 rounded">Post not found.</div>';
            }
        } else {
            // LIST VIEW
            ?>
            <h1 class="text-3xl font-bold mb-6 border-b pb-2 border-gray-200">Berita Terbaru</h1>
            <?php
            $posts = get_posts(array('numberposts' => 10));
            
            if (!empty($posts)):
                foreach ($posts as $post): 
                    $thumb_url = get_the_post_thumbnail_url($post->ID);
                    $categories = get_the_terms($post->ID, 'category');
            ?>
                <article class="mb-8 bg-white p-6 rounded-lg shadow-sm hover:shadow-md transition group">
                    <?php if ($thumb_url): ?>
                    <div class="h-64 bg-gray-200 rounded-lg mb-4 overflow-hidden relative">
                        <img src="<?php echo $thumb_url; ?>" alt="<?php echo htmlspecialchars($post->post_title); ?>" class="w-full h-full object-cover group-hover:scale-105 transition duration-500">
                        <?php if ($categories): ?>
                        <div class="absolute top-4 left-4 flex gap-1">
                            <?php foreach($categories as $cat): ?>
                            <span class="bg-white/90 backdrop-blur text-gray-800 text-xs px-2 py-1 rounded font-bold shadow-sm"><?php echo htmlspecialchars($cat->name); ?></span>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php else: ?>
                        <!-- No Image Placeholder but with Category -->
                         <?php if ($categories): ?>
                        <div class="mb-2 flex gap-1">
                            <?php foreach($categories as $cat): ?>
                            <span class="bg-gray-100 text-gray-600 text-xs px-2 py-1 rounded font-bold"><?php echo htmlspecialchars($cat->name); ?></span>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    <h2 class="text-2xl font-bold mb-2 text-gray-800">
                        <a href="?p=<?php echo $post->ID; ?>" class="hover:text-orion-600 transition"><?php echo htmlspecialchars($post->post_title); ?></a>
                    </h2>
                    <div class="text-sm text-gray-500 mb-4">Diposting pada <?php echo date('d F Y', strtotime($post->post_date)); ?></div>
                    <p class="text-gray-600 mb-4">
                        <?php 
                        $content = strip_tags($post->post_content);
                        if (strlen($content) > 150) {
                            echo substr($content, 0, 150) . '...';
                        } else {
                            echo $content;
                        }
                        ?>
                    </p>
                    <a href="?p=<?php echo $post->ID; ?>" class="inline-block text-orion-600 font-semibold hover:underline">Baca Selengkapnya &rarr;</a>
                </article>
            <?php 
                endforeach;
            else:
            ?>
                <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-yellow-700">Belum ada berita yang diposting. Silakan tambahkan berita dari Admin Panel.</p>
                        </div>
                    </div>
                </div>
            <?php endif; 
        } // End List View
        ?>
    </div>

    <!-- Sidebar -->
    <aside class="md:col-span-1 space-y-8">
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="text-xl font-bold mb-4 border-b pb-2 text-gray-800">Kategori</h3>
            <?php 
            $cats = get_terms('category', array('hide_empty' => true));
            if ($cats):
            ?>
            <ul class="space-y-2">
                <?php foreach($cats as $cat): ?>
                <li>
                    <a href="#" class="group flex justify-between items-center text-gray-600 hover:text-orion-600 transition">
                        <span><?php echo htmlspecialchars($cat->name); ?></span> 
                        <span class="bg-gray-100 group-hover:bg-orion-100 text-gray-500 group-hover:text-orion-600 px-2 py-0.5 rounded-full text-xs font-medium transition"><?php echo $cat->count; ?></span>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>
            <?php else: ?>
                <p class="text-gray-500 text-sm italic">Belum ada kategori.</p>
            <?php endif; ?>
        </div>

        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="text-xl font-bold mb-4 border-b pb-2 text-gray-800">Berita Populer</h3>
            <div class="space-y-4">
                <!-- Static Popular Posts Mockup -->
                <div class="flex gap-3">
                    <div class="w-16 h-16 bg-gray-200 rounded-md flex-shrink-0 overflow-hidden">
                        <!-- Placeholder image -->
                    </div>
                    <div>
                        <h4 class="text-sm font-bold leading-tight mb-1"><a href="#" class="hover:text-orion-600">Peluncuran Orion CMS v1.0</a></h4>
                        <span class="text-xs text-gray-400">2 Jam lalu</span>
                    </div>
                </div>
            </div>
        </div>
    </aside>
</div>

<?php get_footer(); ?>