<?php get_header(); ?>

<main class="container mx-auto px-4 py-8">

    <!-- Hero Section (First Post) -->
    <?php 
    // Custom query for the first post
    $args = array(
        'posts_per_page' => 1
    );
    $hero_query = new WP_Query($args);
    
    if ($hero_query->have_posts()) : 
        while ($hero_query->have_posts()) : $hero_query->the_post();
            $bg_image = 'https://source.unsplash.com/random/1200x600?technology,nature'; // Fallback
            // Check for featured image (mock logic as we don't have full media integration yet in theme)
            // Ideally: $bg_image = get_the_post_thumbnail_url();
    ?>
    <section class="mb-12 rounded-xl overflow-hidden relative shadow-2xl group">
        <div class="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-105" style="background-image: url('<?php echo $bg_image; ?>');"></div>
        <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/60 to-transparent"></div>
        
        <div class="relative z-10 p-8 md:p-16 flex flex-col justify-end h-[500px] max-w-4xl">
            <span class="inline-block bg-emerald-600 text-white text-xs font-bold px-3 py-1 rounded-full mb-4 w-fit uppercase tracking-wider">Featured Story</span>
            <h2 class="text-3xl md:text-5xl font-bold text-white mb-4 leading-tight">
                <a href="<?php the_permalink(); ?>" class="hover:underline decoration-emerald-500 decoration-4 underline-offset-4">
                    <?php the_title(); ?>
                </a>
            </h2>
            <div class="flex items-center text-slate-300 text-sm mb-6">
                <span class="mr-4 flex items-center">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                    Orion Editor
                </span>
                <span class="flex items-center">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                    <?php echo date('F j, Y', strtotime($post->post_date)); ?>
                </span>
            </div>
            <p class="text-slate-200 text-lg line-clamp-2 md:line-clamp-3 font-serif">
                <?php echo wp_trim_words($post->post_content, 30); ?>
            </p>
        </div>
    </section>
    <?php 
        endwhile; 
    endif; 
    
    // Reset Post Data not needed strictly here but good practice
    // wp_reset_postdata(); 
    ?>

    <div class="grid grid-cols-1 lg:grid-cols-12 gap-12">
        
        <!-- Main Content Column -->
        <div class="lg:col-span-8">
            <div class="flex items-center justify-between mb-8 border-b-2 border-slate-200 pb-2">
                <h3 class="text-2xl font-bold text-slate-800 border-b-4 border-emerald-500 -mb-[10px] pb-2 inline-block">Latest Stories</h3>
                <a href="#" class="text-sm font-semibold text-emerald-600 hover:text-emerald-800">View All &rarr;</a>
            </div>

            <div class="space-y-10">
                <?php 
                // Main Loop (skipping the first one if we wanted, but for now showing all)
                if ( have_posts() ) : 
                    while ( have_posts() ) : the_post(); 
                ?>
                <article class="flex flex-col md:flex-row gap-6 group">
                    <div class="md:w-1/3 overflow-hidden rounded-lg">
                        <a href="<?php the_permalink(); ?>">
                            <img src="https://source.unsplash.com/random/400x300?sig=<?php echo $post->ID; ?>" alt="<?php the_title(); ?>" class="w-full h-48 md:h-full object-cover transform group-hover:scale-110 transition-transform duration-500">
                        </a>
                    </div>
                    <div class="md:w-2/3 flex flex-col justify-center">
                        <div class="mb-2">
                            <span class="text-xs font-bold text-emerald-600 uppercase tracking-wide">Category</span>
                        </div>
                        <h2 class="text-xl font-bold text-slate-800 mb-2 group-hover:text-emerald-600 transition-colors font-serif">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h2>
                        <p class="text-slate-600 text-sm mb-4 line-clamp-2 leading-relaxed">
                            <?php echo wp_trim_words($post->post_content, 25); ?>
                        </p>
                        <div class="flex items-center text-xs text-slate-400 font-medium">
                            <span class="uppercase">Read More</span>
                            <svg class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                        </div>
                    </div>
                </article>
                <hr class="border-slate-100 last:hidden">
                <?php 
                    endwhile; 
                else: 
                ?>
                <p class="text-center py-10 text-slate-500">No posts found.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Sidebar -->
        <aside class="lg:col-span-4 space-y-10">
            
            <!-- Newsletter Widget -->
            <div class="bg-emerald-50 p-6 rounded-xl border border-emerald-100">
                <h4 class="font-bold text-slate-800 mb-2 font-serif text-lg">Subscribe to Newsletter</h4>
                <p class="text-sm text-slate-600 mb-4">Get the latest updates directly to your inbox.</p>
                <form class="space-y-3">
                    <input type="email" placeholder="Your email address" class="w-full px-4 py-2 rounded-lg border border-emerald-200 focus:outline-none focus:ring-2 focus:ring-emerald-500 bg-white">
                    <button type="submit" class="w-full bg-emerald-600 text-white font-bold py-2 rounded-lg hover:bg-emerald-700 transition-colors">Subscribe</button>
                </form>
            </div>

            <!-- Categories Widget -->
            <div>
                <h4 class="font-bold text-slate-800 mb-4 text-lg border-l-4 border-emerald-500 pl-3">Explore Topics</h4>
                <ul class="space-y-2">
                    <?php 
                    $categories = get_categories();
                    if ($categories) :
                        foreach($categories as $cat):
                    ?>
                    <li>
                        <a href="<?php echo get_category_link($cat); ?>" class="flex justify-between items-center group py-2 border-b border-slate-100 hover:bg-slate-50 px-2 rounded transition-colors">
                            <span class="text-slate-600 group-hover:text-emerald-600 font-medium"><?php echo $cat->name; ?></span>
                            <span class="bg-slate-100 text-slate-500 text-xs px-2 py-1 rounded-full group-hover:bg-emerald-100 group-hover:text-emerald-700"><?php echo $cat->count; ?></span>
                        </a>
                    </li>
                    <?php 
                        endforeach;
                    else:
                    ?>
                    <li class="text-slate-500 text-sm italic">No categories found.</li>
                    <?php endif; ?>
                </ul>
            </div>

            <!-- Popular News Widget -->
            <div>
                <h4 class="font-bold text-slate-800 mb-4 text-lg border-l-4 border-emerald-500 pl-3">Popular News</h4>
                <div class="space-y-4">
                    <?php
                    $popular_args = array(
                        'numberposts' => 5,
                        'orderby' => 'rand'
                    );
                    $popular_posts = get_posts($popular_args);
                    
                    if ($popular_posts) :
                        foreach ($popular_posts as $post) : setup_postdata($post);
                    ?>
                    <div class="flex gap-4 group">
                        <div class="w-20 h-20 flex-shrink-0 rounded-lg overflow-hidden bg-slate-100">
                             <!-- Fallback image logic same as main loop -->
                            <img src="https://source.unsplash.com/random/200x200?sig=<?php echo $post->ID; ?>" alt="<?php the_title(); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                        </div>
                        <div class="flex flex-col justify-center">
                            <h5 class="font-bold text-slate-800 text-sm leading-snug mb-1 group-hover:text-emerald-600 transition-colors font-serif line-clamp-2">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h5>
                            <span class="text-xs text-slate-400"><?php echo date('M j, Y', strtotime($post->post_date)); ?></span>
                        </div>
                    </div>
                    <?php 
                        endforeach;
                        wp_reset_postdata();
                    else:
                    ?>
                    <p class="text-sm text-slate-500">No popular news available.</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Ad / Banner Placeholder -->
            <div class="bg-slate-200 h-64 rounded-xl flex items-center justify-center text-slate-400 font-bold uppercase tracking-widest border-2 border-dashed border-slate-300">
                Ad Space
            </div>

        </aside>

    </div>
</main>

<?php get_footer(); ?>
