<?php get_header(); ?>

<!-- Hero Section -->
<section class="relative bg-slate-900 text-white py-24 border-b-4 border-pmc-gold">
    <div class="absolute inset-0 opacity-20 bg-[url('https://www.transparenttextures.com/patterns/carbon-fibre.png')]"></div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 text-center">
        <h1 class="text-5xl md:text-6xl font-stencil uppercase tracking-widest text-pmc-gold mb-4">
            Operational Capabilities
        </h1>
        <p class="text-xl text-slate-400 max-w-3xl mx-auto font-light">
            Advanced tactical solutions for high-risk environments. Precision. Stealth. Execution.
        </p>
    </div>
</section>

<!-- Capabilities Grid -->
<section class="py-20 bg-slate-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            
            <!-- Capability 1 -->
            <a href="service.php?s=close-protection" class="bg-slate-900 border border-slate-700 hover:border-pmc-gold transition-all duration-300 p-8 group block hover:-translate-y-2">
                <div class="w-16 h-16 bg-pmc-green/20 rounded-lg flex items-center justify-center mb-6 group-hover:bg-pmc-gold/20 transition-colors">
                    <svg class="w-8 h-8 text-pmc-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-stencil text-white mb-4">Close Protection</h3>
                <p class="text-slate-400 mb-6">
                    Elite personal security details for high-value individuals in hostile territories. 24/7 surveillance and rapid extraction protocols.
                </p>
                <ul class="text-sm text-pmc-green space-y-2">
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Executive Protection</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Convoy Security</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Route Reconnaissance</li>
                </ul>
            </a>

            <!-- Capability 2 -->
            <a href="service.php?s=secure-logistics" class="bg-slate-900 border border-slate-700 hover:border-pmc-gold transition-all duration-300 p-8 group block hover:-translate-y-2">
                <div class="w-16 h-16 bg-pmc-green/20 rounded-lg flex items-center justify-center mb-6 group-hover:bg-pmc-gold/20 transition-colors">
                    <svg class="w-8 h-8 text-pmc-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-stencil text-white mb-4">Secure Logistics</h3>
                <p class="text-slate-400 mb-6">
                    Secure supply chain management and asset transport in non-permissive environments. Air, land, and sea capabilities.
                </p>
                <ul class="text-sm text-pmc-green space-y-2">
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Secure Transport</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Supply Chain Security</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Emergency Resupply</li>
                </ul>
            </a>

            <!-- Capability 3 -->
            <a href="service.php?s=rapid-response" class="bg-slate-900 border border-slate-700 hover:border-pmc-gold transition-all duration-300 p-8 group block hover:-translate-y-2">
                <div class="w-16 h-16 bg-pmc-green/20 rounded-lg flex items-center justify-center mb-6 group-hover:bg-pmc-gold/20 transition-colors">
                    <svg class="w-8 h-8 text-pmc-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-stencil text-white mb-4">Rapid Response</h3>
                <p class="text-slate-400 mb-6">
                    Quick Reaction Forces (QRF) ready to deploy within minutes. Crisis management and hostage rescue operations.
                </p>
                <ul class="text-sm text-pmc-green space-y-2">
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Hostage Rescue</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Medical Evacuation</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Site Security</li>
                </ul>
            </a>

            <!-- Capability 4 -->
            <a href="service.php?s=intelligence" class="bg-slate-900 border border-slate-700 hover:border-pmc-gold transition-all duration-300 p-8 group block hover:-translate-y-2">
                <div class="w-16 h-16 bg-pmc-green/20 rounded-lg flex items-center justify-center mb-6 group-hover:bg-pmc-gold/20 transition-colors">
                    <svg class="w-8 h-8 text-pmc-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-stencil text-white mb-4">Intelligence</h3>
                <p class="text-slate-400 mb-6">
                    Advanced reconnaissance and intelligence gathering. Drone surveillance, signal interception, and threat analysis.
                </p>
                <ul class="text-sm text-pmc-green space-y-2">
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Drone Operations</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Cyber Intelligence</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Threat Assessment</li>
                </ul>
            </a>

            <!-- Capability 5 -->
            <a href="service.php?s=training" class="bg-slate-900 border border-slate-700 hover:border-pmc-gold transition-all duration-300 p-8 group block hover:-translate-y-2">
                <div class="w-16 h-16 bg-pmc-green/20 rounded-lg flex items-center justify-center mb-6 group-hover:bg-pmc-gold/20 transition-colors">
                    <svg class="w-8 h-8 text-pmc-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-stencil text-white mb-4">Training & Advisory</h3>
                <p class="text-slate-400 mb-6">
                    Capacity building for local forces. Tactical training, leadership development, and operational planning support.
                </p>
                <ul class="text-sm text-pmc-green space-y-2">
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> CQB Training</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Marksmanship</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Strategic Planning</li>
                </ul>
            </a>

            <!-- Capability 6 -->
            <a href="service.php?s=maritime" class="bg-slate-900 border border-slate-700 hover:border-pmc-gold transition-all duration-300 p-8 group block hover:-translate-y-2">
                <div class="w-16 h-16 bg-pmc-green/20 rounded-lg flex items-center justify-center mb-6 group-hover:bg-pmc-gold/20 transition-colors">
                    <svg class="w-8 h-8 text-pmc-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-stencil text-white mb-4">Maritime Security</h3>
                <p class="text-slate-400 mb-6">
                    Anti-piracy operations and vessel protection. Port security assessments and offshore asset defense.
                </p>
                <ul class="text-sm text-pmc-green space-y-2">
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Anti-Piracy</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Vessel Escort</li>
                    <li class="flex items-center"><span class="w-2 h-2 bg-pmc-gold mr-2"></span> Port Security</li>
                </ul>
            </a>

        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-16 bg-pmc-green text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-stencil uppercase mb-6">Ready to Deploy?</h2>
        <p class="text-xl mb-8 max-w-2xl mx-auto opacity-90">
            Contact our command center for a secure consultation regarding your operational requirements.
        </p>
        <a href="index.php#contact" class="inline-block px-8 py-4 bg-slate-900 hover:bg-slate-800 text-pmc-gold font-bold uppercase tracking-wider border border-pmc-gold transition-all">
            Initiate Contact
        </a>
    </div>
</section>

<?php get_footer(); ?>