<footer class="bg-slate-900 text-slate-400 py-16 border-t border-slate-800">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-12">
            <div class="md:col-span-1">
                <a href="<?php echo site_url(); ?>" class="flex items-center gap-2 mb-6 group">
                    <div class="w-10 h-10 bg-gradient-to-br from-primary-600 to-primary-800 rounded-lg flex items-center justify-center text-white font-bold text-xl shadow-lg shadow-primary-500/30">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-white leading-none">Orion<span class="text-primary-500">School</span></h2>
                        <p class="text-[10px] text-slate-500 tracking-[0.2em] uppercase font-semibold mt-0.5">Unggul & Berkarakter</p>
                    </div>
                </a>
                <p class="mb-6 leading-relaxed">Mewujudkan generasi muda yang cerdas, berkarakter mulia, dan siap menghadapi tantangan global.</p>
                <div class="flex space-x-4">
                    <a href="<?php echo get_option('orion_school_facebook', '#'); ?>" class="w-10 h-10 rounded-full bg-slate-800 flex items-center justify-center hover:bg-primary-600 hover:text-white transition duration-300">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd"></path></svg>
                    </a>
                    <a href="<?php echo get_option('orion_school_instagram', '#'); ?>" class="w-10 h-10 rounded-full bg-slate-800 flex items-center justify-center hover:bg-pink-600 hover:text-white transition duration-300">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772 4.902 4.902 0 011.772-1.153c.636-.247 1.363-.416 2.427-.465 1.067-.047 1.407-.06 4.123-.06h.08zm-1.634 8.527a3.465 3.465 0 114.897 4.897 3.465 3.465 0 01-4.897-4.897zM20.944 6.647a1.35 1.35 0 10-2.7 0 1.35 1.35 0 002.7 0z" clip-rule="evenodd"></path></svg>
                    </a>
                    <a href="<?php echo get_option('orion_school_youtube', '#'); ?>" class="w-10 h-10 rounded-full bg-slate-800 flex items-center justify-center hover:bg-red-600 hover:text-white transition duration-300">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M19.812 5.418c.861.23 1.538.907 1.768 1.768C21.998 8.746 22 12 22 12s0 3.255-.418 4.814a2.504 2.504 0 01-1.768 1.768c-1.56.419-7.814.419-7.814.419s-6.255 0-7.814-.419a2.505 2.505 0 01-1.768-1.768C2 15.255 2 12 2 12s0-3.254.419-4.813a2.503 2.503 0 011.768-1.768C5.744 5 11.998 5 11.998 5s6.255 0 7.814.418zM15.194 12l-4.039-2.324v4.648L15.194 12z" clip-rule="evenodd"></path></svg>
                    </a>
                </div>
            </div>
            
            <div>
                <h3 class="text-white font-bold text-lg mb-6">Tautan Cepat</h3>
                <ul class="space-y-3">
                    <li><a href="?page=sejarah" class="hover:text-primary-400 transition flex items-center"><span class="w-1.5 h-1.5 bg-primary-500 rounded-full mr-2"></span> Sejarah</a></li>
                    <li><a href="?page=visi-misi" class="hover:text-primary-400 transition flex items-center"><span class="w-1.5 h-1.5 bg-primary-500 rounded-full mr-2"></span> Visi & Misi</a></li>
                    <li><a href="?page=guru" class="hover:text-primary-400 transition flex items-center"><span class="w-1.5 h-1.5 bg-primary-500 rounded-full mr-2"></span> Guru & Staf</a></li>
                    <li><a href="?page=berita" class="hover:text-primary-400 transition flex items-center"><span class="w-1.5 h-1.5 bg-primary-500 rounded-full mr-2"></span> Berita Sekolah</a></li>
                    <li><a href="?page=ppdb" class="hover:text-primary-400 transition flex items-center"><span class="w-1.5 h-1.5 bg-primary-500 rounded-full mr-2"></span> Info PPDB</a></li>
                </ul>
            </div>
            
            <div>
                <h3 class="text-white font-bold text-lg mb-6">Kontak Kami</h3>
                <ul class="space-y-4">
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-primary-500 mr-3 mt-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                        <span><?php echo nl2br(get_option('orion_school_address', 'Jl. Pendidikan No. 123, Jakarta Selatan, DKI Jakarta 12345')); ?></span>
                    </li>
                    <li class="flex items-center">
                        <svg class="w-5 h-5 text-primary-500 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                        <span><?php echo get_option('orion_school_phone', '(021) 1234-5678'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <svg class="w-5 h-5 text-primary-500 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                        <span><?php echo get_option('orion_school_email', 'info@orionschool.sch.id'); ?></span>
                    </li>
                </ul>
            </div>

            <div>
                <h3 class="text-white font-bold text-lg mb-6">Jam Operasional</h3>
                <ul class="space-y-3">
                    <li class="flex justify-between border-b border-slate-800 pb-2">
                        <span>Senin - Jumat</span>
                        <span class="text-white font-medium">07:00 - 16:00</span>
                    </li>
                    <li class="flex justify-between border-b border-slate-800 pb-2">
                        <span>Sabtu</span>
                        <span class="text-white font-medium">08:00 - 12:00</span>
                    </li>
                    <li class="flex justify-between pb-2">
                        <span>Minggu</span>
                        <span class="text-red-500 font-medium">Tutup</span>
                    </li>
                </ul>
            </div>
        </div>
        
        <div class="border-t border-slate-800 pt-8 mt-8 text-center text-sm">
            <p>&copy; <?php echo date('Y'); ?> Orion School. All rights reserved. Powered by <a href="#" class="text-primary-500 hover:text-primary-400">Orion CMS</a>.</p>
        </div>
    </div>
</footer>

<script>
    // Simple Alpine.js replacement for basic interactivity if Alpine fails to load
    document.addEventListener('DOMContentLoaded', function() {
        // Mobile menu toggle
        const mobileBtn = document.querySelector('button[class*="text-slate-600"][class*="lg:hidden"]');
        const mobileDrawer = document.querySelector('.absolute.top-20.left-0');
        
        if(mobileBtn && mobileDrawer) {
            mobileBtn.addEventListener('click', function() {
                if (mobileDrawer.style.display === 'none' || mobileDrawer.style.display === '') {
                    mobileDrawer.style.display = 'flex';
                } else {
                    mobileDrawer.style.display = 'none';
                }
            });
        }
    });
</script>

<?php if (function_exists('wp_footer')) wp_footer(); ?>
</body>
</html>
