<footer class="bg-white border-t border-gray-200 mt-12 pt-10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <!-- Top Footer: Benefits & Newsletter -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 pb-10 border-b border-gray-100">
            <div>
                <h3 class="text-lg font-bold text-gray-900 mb-2">Tetap Terhubung</h3>
                <p class="text-sm text-gray-500 mb-4">Dapatkan update terbaru tentang promo dan produk baru.</p>
                <div class="flex gap-2">
                    <input type="email" placeholder="Alamat Email Anda" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-shop-500 focus:border-shop-500 block p-2.5">
                    <button class="bg-shop-600 text-white px-6 py-2.5 rounded-lg text-sm font-medium hover:bg-shop-700 transition">Daftar</button>
                </div>
            </div>
            <div class="flex justify-around items-center">
                <div class="text-center">
                    <div class="w-12 h-12 bg-shop-100 rounded-full flex items-center justify-center mx-auto mb-2 text-shop-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                    </div>
                    <span class="text-xs font-semibold text-gray-700">Pembayaran Aman</span>
                </div>
                <div class="text-center">
                    <div class="w-12 h-12 bg-shop-100 rounded-full flex items-center justify-center mx-auto mb-2 text-shop-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                    </div>
                    <span class="text-xs font-semibold text-gray-700">Pengiriman Cepat</span>
                </div>
                <div class="text-center">
                    <div class="w-12 h-12 bg-shop-100 rounded-full flex items-center justify-center mx-auto mb-2 text-shop-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path></svg>
                    </div>
                    <span class="text-xs font-semibold text-gray-700">Layanan 24/7</span>
                </div>
            </div>
        </div>

        <!-- Middle Footer: Links -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 py-10 border-b border-gray-100">
            <div>
                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4"><a href="index.php?page=customer-service" class="hover:text-shop-600">Layanan Pelanggan</a></h4>
                <ul class="space-y-2 text-sm text-gray-500">
                    <li><a href="index.php?page=help-center" class="hover:text-shop-600">Pusat Bantuan</a></li>
                    <li><a href="index.php?page=how-to-buy" class="hover:text-shop-600">Cara Pembelian</a></li>
                    <li><a href="index.php?page=shipping-returns" class="hover:text-shop-600">Pengiriman & Pengembalian</a></li>
                    <li><a href="index.php?page=contact-us" class="hover:text-shop-600">Hubungi Kami</a></li>
                </ul>
            </div>
            <div>
                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4">Tentang Kami</h4>
                <ul class="space-y-2 text-sm text-gray-500">
                    <li><a href="#" class="hover:text-shop-600">Tentang Orion Shop</a></li>
                    <li><a href="#" class="hover:text-shop-600">Karir</a></li>
                    <li><a href="#" class="hover:text-shop-600">Kebijakan Privasi</a></li>
                    <li><a href="#" class="hover:text-shop-600">Media & Pers</a></li>
                </ul>
            </div>
            <div>
                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4">Pembayaran</h4>
                <div class="grid grid-cols-3 gap-2 mb-6">
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">VISA</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">MC</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">ATM</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">BCA</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">BRI</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">QRIS</div>
                </div>
                
                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4">Pengiriman</h4>
                <div class="grid grid-cols-3 gap-2">
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">JNE</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">J&T</div>
                   <div class="bg-gray-100 h-8 rounded flex items-center justify-center text-xs font-bold text-gray-400">SiCepat</div>
                </div>
            </div>
            <div>
                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4">Download Aplikasi</h4>
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-20 h-20 bg-gray-200 rounded p-1">
                         <!-- QR Code Placeholder -->
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=OrionShop" alt="QR" class="w-full h-full">
                    </div>
                    <div class="flex flex-col gap-2">
                        <a href="#" class="block w-28 bg-gray-900 text-white text-xs py-1 px-2 rounded flex items-center justify-center gap-1">
                            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor"><path d="M17.05 20.28c-.98.95-2.05.8-3.08.35-1.09-.46-2.09-.48-3.24 0-1.44.62-2.2.44-3.06-.35C2.79 15.25 3.51 7.59 9.05 7.31c1.35.07 2.29.74 3.08.74 1.18 0 2.29-1.23 3.57-.8 1.55.12 2.65.81 3.4 1.9-3.52 1.69-2.9 6.92.62 8.38-.68 2.1-1.61 4.15-2.67 5.75zm-2.91-14.8c.87-1.3 2.15-1.92 2.15-1.92.25 2.12-1.87 4.2-3.8 4.2-.3 0-.58-.02-.87-.07.05-1.07.61-1.74 1.52-2.21z"/></svg>
                            <span>App Store</span>
                        </a>
                        <a href="#" class="block w-28 bg-gray-900 text-white text-xs py-1 px-2 rounded flex items-center justify-center gap-1">
                            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor"><path d="M3.609 1.814L13.792 12 3.61 22.186a.996.996 0 0 1-1.61-1.026V2.84a.996.996 0 0 1 1.61-1.026zM15.208 13.414l2.122 2.122-2.122 2.122-2.122-2.122 2.122-2.122zm-2.122-2.828l2.122-2.122 2.122 2.122-2.122 2.122-2.122-2.122zm4.244 2.122l2.121 2.121-2.121 2.122-2.121-2.122 2.121-2.121z"/></svg>
                            <span>Google Play</span>
                        </a>
                    </div>
                </div>

                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4">Ikuti Kami</h4>
                <div class="flex space-x-4">
                    <a href="#" class="text-gray-400 hover:text-shop-600">
                        <span class="sr-only">Facebook</span>
                        <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24"><path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd"></path></svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-shop-600">
                        <span class="sr-only">Instagram</span>
                        <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24"><path fill-rule="evenodd" d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772 4.902 4.902 0 011.772-1.153c.636-.247 1.363-.416 2.427-.465C9.673 2.013 10.03 2 12.48 2h.165zm-1.8 1.8c-2.464.01-2.748.02-3.708.064-.962.043-1.485.2-1.83.334-.45.174-.77.38-1.106.716-.335.335-.542.654-.716 1.106-.134.345-.29.868-.334 1.83-.044.96-.055 1.244-.064 3.708v.36c.01 2.464.02 2.748.064 3.708.043.962.2 1.485.334 1.83.174.45.38.77.716 1.106.335.335.654.542 1.106.716.345.134.868.29 1.83.334.96.044 1.244.055 3.708.064h.36c2.464-.01 2.748-.02 3.708-.064.962-.043 1.485-.2 1.83-.334.45-.174.77-.38 1.106-.716.335-.335.542-.654.716-1.106.134-.345.29-.868.334-1.83.044-.96.055-1.244.064-3.708v-.36c-.01-2.464-.02-2.748-.064-3.708-.043-.962-.2-1.485-.334-1.83-.174-.45-.38-.77-.716-1.106-.335-.335-.654-.542-1.106-.716-.345-.134-.868-.29-1.83-.334-.96-.044-1.244-.055-3.708-.064h-.36zm-2.094 5.25a3.75 3.75 0 110 7.5 3.75 3.75 0 010-7.5zm0 1.5a2.25 2.25 0 100 4.5 2.25 2.25 0 000-4.5zM17.812 4.688a1.5 1.5 0 110 3 1.5 1.5 0 010-3z" clip-rule="evenodd"></path></svg>
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Bottom Footer: Copyright -->
        <div class="py-6 flex flex-col md:flex-row justify-between items-center text-sm text-gray-500">
            <p>&copy; <?php echo date('Y'); ?> Orion Shop. All rights reserved.</p>
            <div class="flex space-x-6 mt-4 md:mt-0">
                <a href="#" class="hover:text-shop-600">Indonesia</a>
                <a href="#" class="hover:text-shop-600">Bahasa Indonesia</a>
            </div>
        </div>
    </div>
</footer>

<script>
// Simple countdown timer for flash sale
document.addEventListener('DOMContentLoaded', function() {
    const flashSaleTimer = document.querySelector('#flash-sale-timer');
    if (flashSaleTimer) {
        // Set end time to 24 hours from now
        const endTime = new Date();
        endTime.setHours(endTime.getHours() + 24);
        
        function updateTimer() {
            const now = new Date();
            const diff = endTime - now;
            
            if (diff <= 0) {
                // Reset or stop
                return;
            }
            
            const hours = Math.floor((diff / (1000 * 60 * 60)) % 24);
            const minutes = Math.floor((diff / (1000 * 60)) % 60);
            const seconds = Math.floor((diff / 1000) % 60);
            
            // Format with leading zeros
            const h = hours.toString().padStart(2, '0');
            const m = minutes.toString().padStart(2, '0');
            const s = seconds.toString().padStart(2, '0');
            
            // Update the HTML
            // Assuming structure <span>HH</span>:<span>MM</span>:<span>SS</span>
            const spans = flashSaleTimer.querySelectorAll('span');
            if (spans.length >= 3) {
                spans[0].textContent = h;
                spans[1].textContent = m;
                spans[2].textContent = s;
            }
        }
        
        setInterval(updateTimer, 1000);
        updateTimer();
    }
});
</script>
</body>
</html>