<?php get_header(); ?>

<!-- Hero Section -->
<section class="relative bg-emerald-800 text-white">
    <!-- Background Pattern & Image -->
    <div class="absolute inset-0 opacity-20 hero-pattern"></div>
    <div class="absolute inset-0 bg-gradient-to-r from-emerald-900/90 to-emerald-800/70 z-10"></div>
    <img src="https://images.unsplash.com/photo-1500382017468-9049fed747ef?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80" alt="Village Landscape" class="absolute inset-0 w-full h-full object-cover">
    
    <div class="container mx-auto px-4 py-24 relative z-20">
        <div class="max-w-2xl">
            <span class="inline-block bg-emerald-700 bg-opacity-50 border border-emerald-500 text-emerald-100 px-3 py-1 rounded-full text-sm font-semibold mb-4 backdrop-blur-sm">
                Selamat Datang di Website Resmi
            </span>
            <h1 class="text-4xl md:text-5xl font-bold mb-6 leading-tight">
                Membangun Desa Cerdas, <br>Masyarakat Sejahtera
            </h1>
            <p class="text-emerald-100 text-lg mb-8 leading-relaxed">
                Platform informasi pelayanan publik dan transparansi anggaran desa. Menuju tata kelola pemerintahan yang modern, akuntabel, dan melayani.
            </p>
            <div class="flex flex-wrap gap-4">
                <a href="#layanan" class="bg-yellow-500 hover:bg-yellow-400 text-slate-900 font-bold px-6 py-3 rounded-lg shadow-lg transition transform hover:-translate-y-1">
                    Layanan Warga
                </a>
                <a href="#profil" class="bg-white/10 hover:bg-white/20 border border-white/30 text-white font-semibold px-6 py-3 rounded-lg backdrop-blur-sm transition">
                    Jelajahi Profil Desa
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Stats Cards (Floating) -->
    <div class="container mx-auto px-4 relative z-30 -mb-16 hidden md:block">
        <div class="grid grid-cols-4 gap-6">
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-emerald-500 transform hover:-translate-y-1 transition duration-300">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-slate-500 text-sm font-medium mb-1">Total Penduduk</p>
                        <h4 class="text-3xl font-bold text-slate-800">4,250</h4>
                        <span class="text-xs text-green-600 font-medium flex items-center mt-1">
                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path></svg>
                            +12% tahun ini
                        </span>
                    </div>
                    <div class="p-3 bg-emerald-50 rounded-lg text-emerald-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                    </div>
                </div>
            </div>
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-blue-500 transform hover:-translate-y-1 transition duration-300">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-slate-500 text-sm font-medium mb-1">Kepala Keluarga</p>
                        <h4 class="text-3xl font-bold text-slate-800">1,240</h4>
                        <span class="text-xs text-blue-600 font-medium mt-1 block">Terdata Digital</span>
                    </div>
                    <div class="p-3 bg-blue-50 rounded-lg text-blue-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
                    </div>
                </div>
            </div>
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-yellow-500 transform hover:-translate-y-1 transition duration-300">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-slate-500 text-sm font-medium mb-1">Luas Wilayah</p>
                        <h4 class="text-3xl font-bold text-slate-800">12.5</h4>
                        <span class="text-xs text-slate-400 font-medium mt-1 block">Kilometer Persegi</span>
                    </div>
                    <div class="p-3 bg-yellow-50 rounded-lg text-yellow-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0121 18.382V7.618a1 1 0 01-.553-.894L15 4m0 13V4m0 0L9 7"></path></svg>
                    </div>
                </div>
            </div>
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-purple-500 transform hover:-translate-y-1 transition duration-300">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-slate-500 text-sm font-medium mb-1">Dana Desa</p>
                        <h4 class="text-3xl font-bold text-slate-800">95%</h4>
                        <span class="text-xs text-purple-600 font-medium mt-1 block">Realisasi 2024</span>
                    </div>
                    <div class="p-3 bg-purple-50 rounded-lg text-purple-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mobile Stats (Visible only on mobile) -->
<section class="py-8 bg-slate-50 md:hidden">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-2 gap-4">
            <div class="bg-white p-4 rounded-lg shadow-sm border-l-4 border-emerald-500">
                <p class="text-slate-500 text-xs font-bold">PENDUDUK</p>
                <h4 class="text-2xl font-bold text-slate-800">4,250</h4>
            </div>
            <div class="bg-white p-4 rounded-lg shadow-sm border-l-4 border-blue-500">
                <p class="text-slate-500 text-xs font-bold">KK</p>
                <h4 class="text-2xl font-bold text-slate-800">1,240</h4>
            </div>
        </div>
    </div>
</section>

<!-- Main Content Area -->
<section class="py-16 md:pt-32 bg-slate-50">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
            
            <!-- Left Column: Latest News (2/3 width) -->
            <div class="lg:col-span-2 space-y-12">
                
                <!-- Section Title -->
                <div class="flex justify-between items-end border-b border-slate-200 pb-4">
                    <div>
                        <span class="text-emerald-600 font-bold text-sm tracking-wider uppercase">Kabar Desa</span>
                        <h2 class="text-3xl font-bold text-slate-800 mt-1">Berita Terkini</h2>
                    </div>
                    <a href="#" class="text-sm font-semibold text-emerald-600 hover:text-emerald-700 flex items-center">
                        Lihat Semua <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                    </a>
                </div>

                <!-- Featured Post (Latest) -->
                <?php 
                $latest_posts = get_posts(['limit' => 1]); 
                if (!empty($latest_posts)): 
                    $post = $latest_posts[0];
                ?>
                <article class="group bg-white rounded-2xl shadow-sm overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="md:flex">
                        <div class="md:w-1/2 overflow-hidden">
                            <img src="<?php echo get_post_image_url($post['id']) ?: 'https://images.unsplash.com/photo-1572021335469-31706a17aaef?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80'; ?>" alt="<?php echo $post['title']; ?>" class="w-full h-64 md:h-full object-cover transform group-hover:scale-105 transition duration-500">
                        </div>
                        <div class="p-8 md:w-1/2 flex flex-col justify-center">
                            <div class="flex items-center gap-3 text-xs font-medium text-slate-500 mb-4">
                                <span class="bg-emerald-100 text-emerald-700 px-2 py-1 rounded">Pembangunan</span>
                                <span><?php echo date('d M Y', strtotime($post['created_at'])); ?></span>
                            </div>
                            <h3 class="text-2xl font-bold text-slate-800 mb-4 group-hover:text-emerald-700 transition">
                                <a href="index.php?p=<?php echo $post['id']; ?>"><?php echo $post['title']; ?></a>
                            </h3>
                            <p class="text-slate-600 mb-6 line-clamp-3">
                                <?php echo substr(strip_tags($post['content']), 0, 150) . '...'; ?>
                            </p>
                            <a href="index.php?p=<?php echo $post['id']; ?>" class="inline-flex items-center text-emerald-600 font-bold hover:text-emerald-700">
                                Baca Selengkapnya <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                            </a>
                        </div>
                    </div>
                </article>
                <?php endif; ?>

                <!-- Recent Posts Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <?php 
                    $recent_posts = get_posts(['limit' => 4, 'offset' => 1]);
                    foreach ($recent_posts as $post):
                    ?>
                    <article class="bg-white rounded-xl shadow-sm overflow-hidden hover:shadow-md transition group">
                        <div class="h-48 overflow-hidden relative">
                            <img src="<?php echo get_post_image_url($post['id']) ?: 'https://via.placeholder.com/600x400?text=Berita+Desa'; ?>" class="w-full h-full object-cover transform group-hover:scale-105 transition duration-500">
                            <div class="absolute top-4 left-4">
                                <span class="bg-white/90 backdrop-blur text-slate-800 text-xs font-bold px-2 py-1 rounded shadow-sm">
                                    <?php echo date('d M', strtotime($post['created_at'])); ?>
                                </span>
                            </div>
                        </div>
                        <div class="p-6">
                            <h4 class="text-lg font-bold text-slate-800 mb-2 group-hover:text-emerald-600 transition line-clamp-2">
                                <a href="index.php?p=<?php echo $post['id']; ?>"><?php echo $post['title']; ?></a>
                            </h4>
                            <p class="text-slate-500 text-sm mb-4 line-clamp-2"><?php echo substr(strip_tags($post['content']), 0, 100); ?>...</p>
                            <a href="index.php?p=<?php echo $post['id']; ?>" class="text-sm font-medium text-emerald-600 hover:text-emerald-700">Baca selengkapnya &rarr;</a>
                        </div>
                    </article>
                    <?php endforeach; ?>
                </div>

            </div>

            <!-- Right Column: Sidebar (1/3 width) -->
            <div class="space-y-8">
                
                <!-- Kepala Desa Widget -->
                <div class="bg-white rounded-xl shadow-sm p-6 text-center border-t-4 border-emerald-500">
                    <h3 class="text-lg font-bold text-slate-800 mb-6 border-b pb-2">Kepala Desa</h3>
                    <div class="w-32 h-32 mx-auto mb-4 relative">
                        <div class="absolute inset-0 bg-emerald-100 rounded-full transform translate-x-1 translate-y-1"></div>
                        <img src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?ixlib=rb-1.2.1&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80" alt="Kepala Desa" class="w-full h-full object-cover rounded-full border-4 border-white relative z-10 shadow-md">
                    </div>
                    <h4 class="text-xl font-bold text-slate-800">Bapak Susanto, S.IP</h4>
                    <p class="text-emerald-600 font-medium text-sm mb-4">Periode 2024 - 2030</p>
                    <p class="text-slate-500 text-sm italic mb-6">"Mewujudkan desa yang mandiri, berbudaya, dan berdaya saing melalui inovasi digital."</p>
                    <a href="#" class="block w-full bg-slate-100 hover:bg-slate-200 text-slate-700 font-medium py-2 rounded-lg text-sm transition">
                        Sambutan Kades
                    </a>
                </div>

                <!-- Layanan Mandiri Widget -->
                <div class="bg-emerald-600 rounded-xl shadow-lg p-6 text-white overflow-hidden relative">
                    <div class="absolute -right-6 -bottom-6 text-emerald-500 opacity-20">
                        <svg class="w-32 h-32" fill="currentColor" viewBox="0 0 24 24"><path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                    </div>
                    <h3 class="text-lg font-bold mb-4 relative z-10">Layanan Mandiri</h3>
                    <p class="text-emerald-100 text-sm mb-6 relative z-10">Urus surat pengantar, cek bantuan, dan layanan administrasi lainnya secara online.</p>
                    <ul class="space-y-3 relative z-10">
                        <li>
                            <a href="#" class="flex items-center gap-3 bg-emerald-700 hover:bg-emerald-800 p-3 rounded-lg transition">
                                <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                                <span class="font-medium text-sm">Permohonan Surat</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center gap-3 bg-emerald-700 hover:bg-emerald-800 p-3 rounded-lg transition">
                                <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                <span class="font-medium text-sm">Cek Bantuan Sosial</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center gap-3 bg-emerald-700 hover:bg-emerald-800 p-3 rounded-lg transition">
                                <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                                <span class="font-medium text-sm">Pengaduan Warga</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Agenda Kegiatan Widget -->
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <h3 class="text-lg font-bold text-slate-800 mb-6 border-b pb-2">Agenda Kegiatan</h3>
                    <div class="space-y-4">
                        <div class="flex gap-4">
                            <div class="flex-shrink-0 w-12 text-center">
                                <span class="block text-xs font-bold text-red-500 uppercase">Feb</span>
                                <span class="block text-xl font-bold text-slate-800">10</span>
                            </div>
                            <div>
                                <h5 class="font-bold text-slate-700 text-sm">Musyawarah Desa</h5>
                                <p class="text-xs text-slate-500 mt-1">09:00 WIB @ Balai Desa</p>
                            </div>
                        </div>
                        <div class="flex gap-4">
                            <div class="flex-shrink-0 w-12 text-center">
                                <span class="block text-xs font-bold text-red-500 uppercase">Feb</span>
                                <span class="block text-xl font-bold text-slate-800">14</span>
                            </div>
                            <div>
                                <h5 class="font-bold text-slate-700 text-sm">Posyandu Balita</h5>
                                <p class="text-xs text-slate-500 mt-1">08:00 WIB @ Posyandu Mawar</p>
                            </div>
                        </div>
                        <div class="flex gap-4">
                            <div class="flex-shrink-0 w-12 text-center">
                                <span class="block text-xs font-bold text-red-500 uppercase">Feb</span>
                                <span class="block text-xl font-bold text-slate-800">20</span>
                            </div>
                            <div>
                                <h5 class="font-bold text-slate-700 text-sm">Kerja Bakti Masal</h5>
                                <p class="text-xs text-slate-500 mt-1">07:00 WIB @ Lingkungan RT 01</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- Potensi Desa Gallery -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <span class="text-emerald-600 font-bold text-sm tracking-wider uppercase">Jelajahi</span>
            <h2 class="text-3xl font-bold text-slate-800 mt-1">Potensi Desa</h2>
            <p class="text-slate-500 mt-4 max-w-2xl mx-auto">Mengenal lebih dekat kekayaan alam, budaya, dan produk unggulan yang menjadi kebanggaan desa kami.</p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <a href="#" class="group relative overflow-hidden rounded-xl h-64">
                <img src="https://images.unsplash.com/photo-1599939571322-792a326991f2?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Pertanian" class="w-full h-full object-cover transform group-hover:scale-110 transition duration-500">
                <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent flex items-end p-6">
                    <div>
                        <h4 class="text-white font-bold text-lg">Pertanian</h4>
                        <p class="text-slate-300 text-xs mt-1 opacity-0 group-hover:opacity-100 transition duration-300 transform translate-y-2 group-hover:translate-y-0">Lumbung Padi Berkualitas</p>
                    </div>
                </div>
            </a>
            <a href="#" class="group relative overflow-hidden rounded-xl h-64">
                <img src="https://images.unsplash.com/photo-1596232599295-8a2164479532?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="UMKM" class="w-full h-full object-cover transform group-hover:scale-110 transition duration-500">
                <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent flex items-end p-6">
                    <div>
                        <h4 class="text-white font-bold text-lg">UMKM</h4>
                        <p class="text-slate-300 text-xs mt-1 opacity-0 group-hover:opacity-100 transition duration-300 transform translate-y-2 group-hover:translate-y-0">Kerajinan Tangan Lokal</p>
                    </div>
                </div>
            </a>
            <a href="#" class="group relative overflow-hidden rounded-xl h-64">
                <img src="https://images.unsplash.com/photo-1510797215324-95aa89f43c33?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Wisata Alam" class="w-full h-full object-cover transform group-hover:scale-110 transition duration-500">
                <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent flex items-end p-6">
                    <div>
                        <h4 class="text-white font-bold text-lg">Wisata Alam</h4>
                        <p class="text-slate-300 text-xs mt-1 opacity-0 group-hover:opacity-100 transition duration-300 transform translate-y-2 group-hover:translate-y-0">Air Terjun Bidadari</p>
                    </div>
                </div>
            </a>
            <a href="#" class="group relative overflow-hidden rounded-xl h-64">
                <img src="https://images.unsplash.com/photo-1532186651327-6ac23687d8e5?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Budaya" class="w-full h-full object-cover transform group-hover:scale-110 transition duration-500">
                <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent flex items-end p-6">
                    <div>
                        <h4 class="text-white font-bold text-lg">Budaya</h4>
                        <p class="text-slate-300 text-xs mt-1 opacity-0 group-hover:opacity-100 transition duration-300 transform translate-y-2 group-hover:translate-y-0">Tari Tradisional</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
</section>

<?php get_footer(); ?>
